<?php

namespace App\Http\Controllers\User;


use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use App\Models\Language;
use Validator;
use Mail;
use Session;
use DB;
use App;
use Str;


class ForgotController extends Controller
{

    public function __construct()
    {
        $this->middleware('web');
        $this->middleware('setlang');
    }


    public function showForgotForm()
    {

        return view('user.forgot');
    }

    public function forgot(Request $request)
    {

        $request->validate([
            'email' => 'required'
        ]);
        // Validation Starts
        if (session()->has('lang')) {
            $currentLang = Language::where('code', session()->get('lang'))->first();
        } else {
            $currentLang = Language::where('is_default', 1)->first();
        }
        $input =  $request->all();
        $be = $currentLang->basic_extended;

        if (User::where('email', '=', $request->email)->count() > 0) {
            // user found
            $admin = User::where('email', '=', $request->email)->firstOrFail();
            $autopass = Str::random(8);
            $input['password'] = bcrypt($autopass);

            $admin->update($input);
            $subject = __("Reset Password Request");
            $msg = __("Your New Password is : ") . $autopass;

            $mail = new PHPMailer(true);

            $be->is_smtp = 0;
            if ($be->is_smtp == 1) {
                try {
                    //Server settings
                    $mail->isSMTP();                                          
                    $mail->Host       = $be->smtp_host;                    
                    $mail->SMTPAuth   = true;                                 
                    $mail->Username   = $be->smtp_username;                     
                    $mail->Password   = $be->smtp_password;                               
                    $mail->SMTPSecure = $be->encryption;        
                    $mail->Port       = $be->smtp_port;                                  

                    //Recipients
                    $mail->setFrom($be->from_mail, $be->from_name);
                    $mail->addAddress($request->email);     

                    // Content
                    $mail->isHTML(true);
                    $mail->Subject =  $subject;
                    $mail->Body    = $msg;
                    $mail->CharSet = "UTF-8";
                    $mail->send();
                } catch (Exception $e) { }
            } else {
                try {
                    //Recipients
                    $mail->setFrom($be->from_mail, $be->from_name);
                    $mail->addAddress($request->email);     
                    // Content
                    $mail->isHTML(true);
                    $mail->Subject =  $subject;
                    $mail->Body    = $msg;
                    $mail->send();
                } catch (Exception $e) {
                    die($e->getMessage());
                }
            }

            Session::flash('success', toastrMsg('Your_Password_Reseted_Successfully_Please_Check_your_email_for_new_Password.'));
            return back();
        } else {

            // user not found
            Session::flash('err', 'No_Account_Found_With_This_Email.');
            return back();
        }
    }
}
