<?php

namespace App\Http\Requests\Package;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class PackageStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(): array
    {
        // dd($this->features['Blog']);
        return [
            'title' => 'required|max:255',
            'term' => 'required',
            'price' => 'required',
            'status' => 'required',
            'trial_days' => 'required_if:is_trial,1',
            'themes' => 'required',
            'number_of_blogs' => Rule::requiredIf(function () {
                if (!empty($this->features)) {

                    return in_array('Blog', $this->features);
                }
            }),
            'number_of_blog_categories' => Rule::requiredIf(function () {
                if (!empty($this->features)) {
                    return in_array('Blog', $this->features);
                }
            }),
            'number_of_services' => Rule::requiredIf(function () {
                if (!empty($this->features)) {
                    return in_array('Service', $this->features);
                }
            }),
            'number_of_skills' => Rule::requiredIf(function () {
                if (!empty($this->features)) {
                    return in_array('Skill', $this->features);
                }
            }),
            'number_of_portfolios' => Rule::requiredIf(function () {
                if (!empty($this->features)) {
                    return in_array('Portfolio', $this->features);
                }
            }),
            'number_of_portfolio_categories' => Rule::requiredIf(function () {
                if (!empty($this->features)) {
                    return in_array('Portfolio', $this->features);
                }
            }),
            'number_of_languages' => 'required',
            'number_of_job_expriences' => Rule::requiredIf(function () {
                if (!empty($this->features)) {
                    return in_array('Experience', $this->features);
                }
            }),
            'number_of_education' => Rule::requiredIf(function () {
                if (!empty($this->features)) {
                    return in_array('Experience', $this->features);
                }
            }),
            'number_of_vcards' => Rule::requiredIf(function () {
                if (!empty($this->features)) {
                    return in_array('vCard', $this->features);
                }
            }),


        ];
    }

}
