<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('packages', function (Blueprint $table) {
            $table->integer('number_of_blogs')->nullable();
            $table->integer('number_of_blog_categories')->nullable();
            $table->integer('number_of_services')->nullable();
            $table->integer('number_of_skills')->nullable();
            $table->integer('number_of_portfolios')->nullable();
            $table->integer('number_of_portfolio_categories')->nullable();
            $table->integer('number_of_languages')->nullable();
            $table->integer('number_of_job_expriences')->nullable();
            $table->integer('number_of_education')->nullable();
            $table->string('themes')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('packages', function (Blueprint $table) {
            $table->dropColumn('number_of_blogs');
            $table->dropColumn('number_of_blog_categories');
            $table->dropColumn('number_of_services');
            $table->dropColumn('number_of_skills');
            $table->dropColumn('number_of_portfolios');
            $table->dropColumn('number_of_portfolio_categories');
            $table->dropColumn('number_of_languages');
            $table->dropColumn('number_of_job_expriences');
            $table->dropColumn('number_of_education');
            $table->dropColumn('themes');
        });
    }
};
