<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('basic_settings', function (Blueprint $table) {
            $table->tinyInteger('user_registraion_status')->default(1)->comment('1 = active, 0 = deactive');
            $table->string('user_registration_deactive_img')->nullable();
            $table->longText('user_registration_deactive_text')->nullable();
            $table->integer('user_login_attempts')->default(3);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('basic_settings', function (Blueprint $table) {
            $table->dropColumn('user_registraion_status');
            $table->dropColumn('user_registration_deactive_img');
            $table->dropColumn('user_registration_deactive_text');
            $table->dropColumn('user_login_attempts');
        });
    }
};
