@extends('admin.layout')
@if (Session::has('admin_lang'))
    @php
        $admin_lang = Session::get('admin_lang');
        $cd = str_replace('admin_', '', $admin_lang);
        $default = \App\Models\Language::where('code', $cd)->first();
    @endphp
@else
    @php
        $default = \App\Models\Language::where('is_default', 1)->first();
    @endphp
@endif

@section('content')
<div class="page-header">
  <h4 class="page-title">{{__("Settings")}}</h4>
  <ul class="breadcrumbs">
    <li class="nav-home">
      <a href="{{route('admin.dashboard', ['language' => $default->code])}}">
        <i class="flaticon-home"></i>
      </a>
    </li>
    <li class="separator">
      <i class="flaticon-right-arrow"></i>
    </li>
    <li class="nav-item">
      <a href="#">{{__("Package Management")}}</a>
    </li>
    <li class="separator">
      <i class="flaticon-right-arrow"></i>
    </li>
    <li class="nav-item">
      <a href="#">{{__("Settings")}}</a>
    </li>
  </ul>
</div>

<div class="row">
  <div class="col-md-12">
    <div class="card">
      <div class="card-header">
        <div class="card-title d-inline-block">{{__("Settings")}}</div>

      </div>
      <div class="card-body pt-5 pb-5">
        <div class="row">
          <div class="col-lg-6 offset-lg-3">
            <form id="ajaxEditForm" action="{{route('admin.package.settings.update')}}" method="POST">
              @csrf
              <div id="recurringBilling">
                <div class="form-group">
                  <label>{{__("Remind Before (Days)")}} **</label>
                  <input type="number" name="expiration_reminder" class="form-control"
                    value="{{$abe->expiration_reminder}}">
                    <p id="errexpiration_reminder" class="mb-0 text-danger em"></p>
                  <p class="text-warning mb-0">{{__("Specify how many days before you want to remind your customers about subscription expiration. (via mail)")}}</p>
                </div>
              </div>
            </form>
          </div>
        </div>
      </div>
      <div class="card-footer">
        <div class="form">
          <div class="form-group from-show-notify row">
            <div class="col-12 text-center">
              <button type="submit" data-form="ajaxEditForm" id="updateBtn" class="btn btn-success">{{__("Update")}}</button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

@endsection
