<!DOCTYPE html>
<html lang="en" <?php if($rtl == 1): ?> dir="rtl" <?php endif; ?>>

<head>
    <!--====== Required meta tags ======-->
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="<?php echo $__env->yieldContent('meta-description'); ?>">
    <meta name="keywords" content="<?php echo $__env->yieldContent('meta-keywords'); ?>">
    <?php echo $__env->yieldContent('og-meta'); ?>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />
    <!--====== Title ======-->
    <title><?php echo e($bs->website_title); ?> <?php echo $__env->yieldContent('pagename'); ?></title>
    <!--====== Favicon Icon ======-->
    <link rel="shortcut icon" href="<?php echo e(asset('assets/front/img/' . $bs->favicon)); ?>" type="image/png">
    <!--====== Bootstrap css ======-->
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/plugin.min.css')); ?>">
    <!--====== Default css ======-->
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/default.css')); ?>">
    <!--====== Style css ======-->
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/style.css')); ?>">
    <?php if($rtl == 1): ?>
        <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/rtl-style.css')); ?>">
    <?php endif; ?>
    <!-- base color change -->
    <link href="<?php echo e(asset('assets/front/css/style-base-color.php') . '?color=' . $bs->base_color); ?>" rel="stylesheet">
    <?php echo $__env->yieldContent('styles'); ?>
    <?php if($bs->is_whatsapp == 0 && $bs->is_tawkto == 0): ?>
        <style>
            .back-to-top {
                left: auto;
                right: 30px;
            }
        </style>
    <?php endif; ?>
</head>

<body>
    <?php if($bs->preloader_status == 1): ?>
        <!--====== Start Preloader ======-->
        <div class="preloader">
            <div class="lds-ellipsis">
                <img class="lazy" data-src="<?php echo e(asset('assets/front/img/' . $bs->preloader)); ?>" alt="">
            </div>
        </div><!--====== End Preloader ======-->
    <?php endif; ?>
    <?php if ($__env->exists('front.partials.header')) echo $__env->make('front.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php if(!request()->routeIs('front.index')): ?>
        <!--====== Start Breadcrumbs-section ======-->
        <section class="breadcrumbs-section bg_cover lazy" data-bg="<?php echo e(asset('assets/front/img/' . $bs->breadcrumb)); ?>">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-12">
                        <div class="breadcrumbs-content text-center">
                            <h1><?php echo $__env->yieldContent('breadcrumb-title'); ?></h1>
                            <ul class="breadcrumbs-link">
                                <li><a href="<?php echo e(route('front.index')); ?>"><?php echo e(__('Home')); ?></a></li>
                                <li class="active"><?php echo $__env->yieldContent('breadcrumb-link'); ?></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--====== End Breadcrumbs-section ======-->
    <?php endif; ?>
    <?php echo $__env->yieldContent('content'); ?>
    
    <?php if ($__env->exists('front.partials.footer')) echo $__env->make('front.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <a href="#" class="back-to-top"><i class="fas fa-angle-up"></i></a>
    <?php if($be->cookie_alert_status == 1): ?>
        <div class="cookie">
            <?php echo $__env->make('cookie-consent::index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    <?php endif; ?>
    
    <?php if ($__env->exists('front.partials.popups')) echo $__env->make('front.partials.popups', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
    
    <div id="WAButton"></div>
    <!--====== Jquery js ======-->
    <script src="<?php echo e(asset('assets/front/js/vendor/modernizr-3.6.0.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/front/js/vendor/jquery-3.4.1.min.js')); ?>"></script>
    <!--====== Bootstrap js ======-->
    <script src="<?php echo e(asset('assets/front/js/plugin.min.js')); ?>"></script>
    <script>
        "use strict";
        var rtl = <?php echo e($rtl); ?>;
        var mainurl = "<?php echo e(url('/')); ?>";
        var vap_pub_key = "<?php echo e(env('VAPID_PUBLIC_KEY')); ?>";
    </script>
    <script src="<?php echo e(asset('assets/front/js/enable-push.js')); ?>"></script>
    <!--====== Main js ======-->
    <script src="<?php echo e(asset('assets/front/js/main.js')); ?>"></script>
    <?php echo $__env->yieldContent('scripts'); ?>
    <?php echo $__env->yieldContent('vuescripts'); ?>
    <?php if(session()->has('success')): ?>
        <script>
            "use strict";
            toastr['success']("<?php echo e(__(session('success'))); ?>");
        </script>
    <?php endif; ?>
    <?php if(session()->has('error')): ?>
        <script>
            "use strict";
            toastr['error']("<?php echo e(__(session('error'))); ?>");
        </script>
    <?php endif; ?>
    <?php if(session()->has('warning')): ?>
        <script>
            "use strict";
            toastr['warning']("<?php echo e(__(session('warning'))); ?>");
        </script>
    <?php endif; ?>
    <script>
        "use strict";
        function handleSelect(elm) {
            window.location.href = "<?php echo e(route('changeLanguage', '')); ?>" + "/" + elm.value;
        }
    </script>
    
    <?php if($bs->is_whatsapp == 1): ?>
        <script type="text/javascript">
            "use strict";
            var whatsapp_popup = <?php echo e($bs->whatsapp_popup); ?>;
            var whatsappImg = "<?php echo e(asset('assets/front/img/whatsapp.svg')); ?>";
            $(function() {
                $('#WAButton').floatingWhatsApp({
                    phone: "<?php echo e($bs->whatsapp_number); ?>", //WhatsApp Business phone number
                    headerTitle: "<?php echo e($bs->whatsapp_header_title); ?>", //Popup Title
                    popupMessage: `<?php echo nl2br($bs->whatsapp_popup_message); ?>`, //Popup Message
                    showPopup: whatsapp_popup == 1 ? true : false, //Enables popup display
                    buttonImage: '<img src="' + whatsappImg + '" />', //Button Image
                    position: "right" //Position: left | right
                });
            });
        </script>
    <?php endif; ?>
    <?php if($bs->is_tawkto == 1): ?>
        <?php echo $bs->tawk_to_script; ?>

    <?php endif; ?>
</body>

</html>
<?php /**PATH /Users/samiulalimpratik/Sites/profilex/profilex/resources/views/front/layout.blade.php ENDPATH**/ ?>