<!--====== Start Header ======-->
<header class="header-area header-area-v1">
    <div class="header-navigation">
        <div class="nav-container d-flex align-items-center justify-content-between">
            <!-- site logo -->
            <div class="brand_logo">
                <a href="<?php echo e(route('front.index')); ?>"><img src="<?php echo e(asset('assets/front/img/'.$bs->logo)); ?>" class="img-fluid" alt=""></a>
            </div>
            <div class="nav-menu">
                <!-- Navbar Close Icon -->
                <div class="navbar-close">
                    <div class="cross-wrap"><span class="top"></span><span class="bottom"></span></div>
                </div>
                <div class="mobile-logo">
                    <a href="#"><img src="<?php echo e(asset('assets/front/img/'.$bs->logo)); ?>" class="img-fluid" alt=""></a>
                </div>
                <!-- nav-menu -->
                <nav class="main-menu">
                    <ul>
                        <?php
                            $links = json_decode($menus, true);
                        ?>
                        <?php $__currentLoopData = $links; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $href = getHref($link);
                            ?>
                            <?php if(!array_key_exists("children",$link)): ?>
                                <li class="menu-item"><a href="<?php echo e($href); ?>" target="<?php echo e($link["target"]); ?>"><?php echo e($link["text"]); ?></a></li>
                            <?php else: ?>
                                <li class="menu-item menu-item-has-children">
                                    <a href="<?php echo e($href); ?>" target="<?php echo e($link["target"]); ?>"><?php echo e($link["text"]); ?></a>
                                    <ul class="sub-menu">
                                        <?php $__currentLoopData = $link["children"]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $l2Href = getHref($level2);
                                            ?>
                                            <li><a href="<?php echo e($l2Href); ?>" target="<?php echo e($level2["target"]); ?>"><?php echo e($level2["text"]); ?></a></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </li>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php if(auth()->guard()->guest()): ?>
                            <li class="menu-item d-xl-none d-block"><a href="<?php echo e(route('user.login')); ?>"><?php echo e(__('Login')); ?></a></li>
                        <?php endif; ?>
                        <?php if(auth()->guard()->check()): ?>
                            <li class="menu-item d-xl-none d-block"><a href="<?php echo e(route('user-dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
                        <?php endif; ?>
                    </ul>
                </nav>
            </div>

            <div class="nav-push-item-container">
                <!-- nav push item -->
                <div class="nav-push-item d-none d-xl-block">
                    <?php if(auth()->guard()->guest()): ?>
                        <div class="navbar-btn">
                            <a href="<?php echo e(route('user.login')); ?>" class="main-btn"><i class="fal fa-sign-in-alt"></i><?php echo e(__('Login')); ?></a>
                        </div>
                    <?php endif; ?>
                    <?php if(auth()->guard()->check()): ?>
                        <div class="navbar-btn">
                            <a href="<?php echo e(route('user-dashboard')); ?>" class="main-btn"><i class="far fa-user"></i><?php echo e(__('Dashboard')); ?></a>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="nav-push-item language">
                    <div class="navbar-btn">
                        <?php if(!empty($currentLang)): ?>
                            <select onchange="handleSelect(this)">
                                <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option
                                        value="<?php echo e($lang->code); ?>" <?php echo e($currentLang->code === $lang->code ?"selected":""); ?>><?php echo e($lang->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        <?php endif; ?>
                    </div>
                </div>
    
                <!-- Navbar Toggler -->
                <div class="navbar-toggler">
                    <span></span><span></span><span></span>
                </div>
            </div>
        </div>
    </div>
</header><!--====== End Header ======-->
<?php /**PATH /Users/samiulalimpratik/Sites/profilex/profilex/resources/views/front/partials/header.blade.php ENDPATH**/ ?>